#include "stdafx.h"														//
#include <stdio.h>														// sprintf() 
#include <assert.h>														//
#include "RegTools.h"													// 
#include "windows.h"													// HKEY



bool SetDataToRegistry( const char *szAppName, const char *szBin32Path, const bool bShowWindow, const bool bHideCustom )
{
	assert(szAppName);

	HKEY  hKey;
	DWORD size = 512;

	bool bRet=true;

	char szSubKey[512];

	sprintf(szSubKey,"Software\\Crytek\\%s",szAppName);

	// Create and open key and subkey.
	LONG lResult = RegCreateKeyEx(HKEY_CURRENT_USER,szSubKey,0,NULL,REG_OPTION_NON_VOLATILE,KEY_ALL_ACCESS, NULL, &hKey, NULL) ;

	if(ERROR_SUCCESS != lResult)
		return false;

	{
		lResult = RegSetValueEx(hKey,"Bin32Path", 0, REG_SZ, (BYTE *)szBin32Path, strlen(szBin32Path)+1) ;
		if( ERROR_SUCCESS != lResult )
			bRet=false;
	}

	{
		DWORD dwVal = bShowWindow?1:0;
		lResult = RegSetValueEx(hKey,"ShowWindow", 0, REG_DWORD, (BYTE *)&dwVal, sizeof(dwVal)) ;
		if( ERROR_SUCCESS != lResult )
			bRet=false;
	}

	{
		DWORD dwVal = bHideCustom?1:0;
		lResult = RegSetValueEx(hKey,"HideCustom", 0, REG_DWORD, (BYTE *)&dwVal, sizeof(dwVal)) ;
		if( ERROR_SUCCESS != lResult )
			bRet=false;
	}

	RegCloseKey( hKey );

	return bRet;
}

const char* GetDataFromRegistry( const char *szAppName, bool &bShowWindow, bool &bHideCustom )
{
	assert(szAppName);
	static TCHAR strNull[2] = "";
	static TCHAR strPath[512];
	HKEY  key;
	DWORD type, size = 512;

	char szSubKey[512];

	sprintf(szSubKey,"Software\\Crytek\\%s",szAppName);

	const char *szRet = strNull;

	// Open the appropriate registry key
	LONG result = RegOpenKeyEx( HKEY_CURRENT_USER,szSubKey,0, KEY_READ, &key );
	if( ERROR_SUCCESS != result )
		return szRet;

	{
		result = RegQueryValueEx( key, "Bin32Path", NULL,&type, (BYTE*)strPath, &size );
		if( ERROR_SUCCESS == result )
			szRet=strPath;
	}

	{
		DWORD dwVal;
		size=sizeof(dwVal);

		result = RegQueryValueEx( key, "ShowWindow", NULL,&type, (LPBYTE)&dwVal, &size );

		if(ERROR_SUCCESS==result && type==REG_DWORD)
			bShowWindow = (dwVal!=0);
		else
			bShowWindow=false;
	}

	{
		DWORD dwVal;
		size=sizeof(dwVal);

		result = RegQueryValueEx( key, "HideCustom", NULL,&type, (LPBYTE)&dwVal, &size );

		if(ERROR_SUCCESS==result && type==REG_DWORD)
			bHideCustom = (dwVal!=0);
		else
			bHideCustom=false;
	}

	RegCloseKey( key );

	return szRet;
}
